<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_HTML5_Video'))) {
		class WPBakeryShortCode_TS_VCSC_HTML5_Video extends WPBakeryShortCode {};
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                          => __( "TS Projekktor Video", "ts_visual_composer_extend" ),
		"base"                          => "TS_VCSC_HTML5_Video",
		"icon" 	                        => "ts-composer-element-icon-html5-video",
		"category"                      => __( "Composium", "ts_visual_composer_extend" ),
		"description"                   => __("Place a Projekktor video element", "ts_visual_composer_extend"),
		"admin_enqueue_js"              => "",
		"admin_enqueue_css"             => "",
		"params"                        => array(
			// Video Sources
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_1",
				"seperator"				=> "Video Sources",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "MP4 Video Source", "ts_visual_composer_extend" ),
				"param_name"		    => "video_mp4_source",
				"value"                 => "true",
				"description"		    => __( "Switch the toggle if you want to use a local or remote MP4 video file.", "ts_visual_composer_extend" )
			),
			array(
				"type"                  => "videoselect",
				"heading"               => __( "MP4 Video", "ts_visual_composer_extend" ),
				"param_name"            => "video_mp4_local",
				"video_format"			=> "mp4,m4v",
				"value"                 => "",
				"description"           => __( "Select a local MP4 video from WordPress.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_mp4_source", 'value' => 'true' ),
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "MP4 Video", "ts_visual_composer_extend" ),
				"param_name"            => "video_mp4_remote",
				"value"                 => "",
				"description"           => __( "Enter the remote path to the MP4 version of the video.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_mp4_source", 'value' => 'false' ),
			),				
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "WEBM Video Source", "ts_visual_composer_extend" ),
				"param_name"		    => "video_webm_source",
				"value"                 => "true",
				"description"		    => __( "Switch the toggle if you want to use a local or remote WEBM video file.", "ts_visual_composer_extend" )
			),
			array(
				"type"                  => "videoselect",
				"heading"               => __( "WEBM Video", "ts_visual_composer_extend" ),
				"param_name"            => "video_webm_local",
				"video_format"			=> "webm",
				"value"                 => "",
				"description"           => __( "Select a local WEBM video from WordPress.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_webm_source", 'value' => 'true' ),
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "WEBM Video", "ts_visual_composer_extend" ),
				"param_name"            => "video_webm_remote",
				"value"                 => "",
				"description"           => __( "Enter the remote path to the WEBM version of the video.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_webm_source", 'value' => 'false' ),
			),				
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "OGV Video Source", "ts_visual_composer_extend" ),
				"param_name"		    => "video_ogg_source",
				"value"                 => "true",
				"description"		    => __( "Switch the toggle if you want to use a local or remote OGV video file.", "ts_visual_composer_extend" )
			),
			array(
				"type"                  => "videoselect",
				"heading"               => __( "OGV Video", "ts_visual_composer_extend" ),
				"param_name"            => "video_ogg_local",
				"video_format"			=> "ogg,ogv",
				"value"                 => "",
				"description"           => __( "Select a local OGV video from WordPress.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_ogg_source", 'value' => 'true' ),
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "OGV Video", "ts_visual_composer_extend" ),
				"param_name"            => "video_ogg_remote",
				"value"                 => "",
				"description"           => __( "Enter the remote path to the OGV version of the video.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_ogg_source", 'value' => 'false' ),
			),
			// Player Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_2",
				"seperator"				=> "Player Settings",
				"group" 				=> "Player Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Open in Lightbox", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_lightbox",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle to show the video in a lightbox.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Embed via iFrame", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_iframe",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if the video should be embedded indirectly via iFrame, or directly into the page.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
				"group" 				=> "Player Settings",
			),			
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Player Theme", "ts_visual_composer_extend" ),
				"param_name"		    => "video_theme",
				"value"                 => array(
					__("Maccaco", "ts_visual_composer_extend")					=> "maccaco",                        
					__("Totally Looks Alike", "ts_visual_composer_extend")		=> "totallylookslike",
					__("Minimum", "ts_visual_composer_extend")					=> "minimum",
				),
				"description"		    => __( "Select the overall theme for the player.", "ts_visual_composer_extend" ),
				"dependency"		    => "",
				"group" 				=> "Player Settings",
			),				
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Video Sizing", "ts_visual_composer_extend" ),
				"param_name"		    => "video_objectfit",
				"value"                 => array(
					__("Aspect-Ratio", "ts_visual_composer_extend")				=> "aspectratio",
					__("Fill", "ts_visual_composer_extend")                  	=> "fill",
					__("None", "ts_visual_composer_extend")                 	=> "none",
				),
				"description"           => __( "Select how the video should be sized inside the player container.", "ts_visual_composer_extend" ),
				"dependency"            => "",
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Show as Fixed Player", "ts_visual_composer_extend" ),
				"param_name"		    => "video_fixed",
				"value"                 => "false",
				"admin_label"           => true,
				"description"		    => __( "Switch the toggle if you want to show the player fixed on the screen; only if video is not shown in lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Fixed Position", "ts_visual_composer_extend" ),
				"param_name"            => "video_fixed_position",
				"width"                 => 150,
				"value"                 => array(
					__( 'Bottom Left', "ts_visual_composer_extend" )		=> "bottomleft",
					__( 'Bottom Right', "ts_visual_composer_extend" )		=> "bottomright",
					__( 'Top Left', "ts_visual_composer_extend" )			=> "topleft",
					__( 'Top Right', "ts_visual_composer_extend" )			=> "topright",
				),
				"description"           => __( "Select the fixed position for the player on the screen.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Fixed Adjustment", "ts_visual_composer_extend" ),
				"param_name"            => "video_fixed_adjust",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "500",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define an additional position adjustment for the fixed player; i.e. to account for fixed menu bars.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Fixed Control", "ts_visual_composer_extend" ),
				"param_name"            => "video_fixed_switch",
				"width"                 => 150,
				"value"                 => array(
					__( 'Show / Hide Toggle', "ts_visual_composer_extend" )	=> "toggle",
					__( 'Remove Switch', "ts_visual_composer_extend" )		=> "remove",
					__( 'None', "ts_visual_composer_extend" )				=> "none",
				),
				"description"           => __( "Select if and which additional controls should be added to the fixed player.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Show on Page Load", "ts_visual_composer_extend" ),
				"param_name"		    => "video_fixed_show",
				"value"                 => "true",
				"admin_label"           => false,
				"description"		    => __( "Switch the toggle if you want to show the fixed player on page load or initially hide it.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_fixed_switch", 'value' => 'toggle' ),
				"group" 				=> "Player Settings",
			),		
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Fixed Width", "ts_visual_composer_extend" ),
				"param_name"            => "video_fixed_width",
				"value"                 => "250",
				"min"                   => "250",
				"max"                   => "500",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define the width for the fixed player.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Fixed Height", "ts_visual_composer_extend" ),
				"param_name"            => "video_fixed_height",
				"value"                 => "140",
				"min"                   => "100",
				"max"                   => "500",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define the height for the fixed player.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
				"group" 				=> "Player Settings",
			),	
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Video Poster", "ts_visual_composer_extend" ),
				"param_name"            => "video_poster",
				"value"                 => "",
				"description"           => __( "Select the image that should be used as video poster.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),				
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Poster Sizing", "ts_visual_composer_extend" ),
				"param_name"		    => "video_posterfit",
				"value"                 => array(
					__("Aspect-Ratio", "ts_visual_composer_extend")				=> "aspectratio",
					__("Fill", "ts_visual_composer_extend")                  	=> "fill",
					__("None", "ts_visual_composer_extend")                 	=> "none",
				),
				"description"           => __( "Select how the poster image should be sized inside the player container.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),				
			array(
				"type"                  => "textfield",
				"heading"               => __( "Video Title", "ts_visual_composer_extend" ),
				"param_name"            => "video_title",
				"value"                 => "",
				"description"           => __( "Enter a title or name for the video.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Video Volume", "ts_visual_composer_extend" ),
				"param_name"            => "video_volume",
				"value"                 => "50",
				"min"                   => "0",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the startup volume for the media; set to 0 (Zero) to mute; desktop only (valid for first session).", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Video Fullscreen", "ts_visual_composer_extend" ),
				"param_name"		    => "video_fullscreen",
				"value"                 => "true",
				"admin_label"           => true,
				"description"		    => __( "Switch the toggle if you want the media to have a fullscreen option.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Video Auto-Play", "ts_visual_composer_extend" ),
				"param_name"		    => "video_auto",
				"value"                 => "false",
				"admin_label"           => true,
				"description"		    => __( "Switch the toggle if you want the media to start playing upon page load (non-mobile devices).", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),			
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Auto-Play On Mobile", "ts_visual_composer_extend" ),
				"param_name"		    => "video_mobile",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want to force the auto-play on mobile devices as well.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "video_auto", 'value' => 'true' ),
				"group" 				=> "Player Settings",
			),			
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Video Auto-Stop", "ts_visual_composer_extend" ),
				"param_name"		    => "video_stop",
				"value"                 => "true",
				"admin_label"           => true,
				"description"		    => __( "Switch the toggle if you want all other medias to stop once this one starts playing.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Video Loop", "ts_visual_composer_extend" ),
				"param_name"		    => "video_loop",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want the media to loop and start over each time it has finished.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Video Share Buttons", "ts_visual_composer_extend" ),
				"param_name"		    => "video_share",
				"value"                 => "true",
				"admin_label"           => true,
				"description"		    => __( "Switch the toggle if you want to show social share button for the media.", "ts_visual_composer_extend" ),
				"group" 				=> "Player Settings",
			),
			// Logo Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_3",
				"seperator"				=> "Logo Settings",
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Show Logo", "ts_visual_composer_extend" ),
				"param_name"            => "video_logo_show",
				"width"                 => 150,
				"value"                 => array(
					__( 'No Logo', "ts_visual_composer_extend" )							=> "logonone",
					__( 'Show Logo on Top of Video', "ts_visual_composer_extend" )			=> "logotop",
					__( 'Show Logo in Controlbar', "ts_visual_composer_extend" )			=> "logocontrol",
				),
				"description"           => __( "Select if and where an additional logo should be shown.", "ts_visual_composer_extend" ),
				"dependency"            => "",
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Logo Image", "ts_visual_composer_extend" ),
				"param_name"            => "video_logo_image",
				"value"                 => "",
				"description"           => __( "Select the logo image that will be shown on top of the media or in the control bar.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_logo_show", 'value' => array('logotop','logocontrol') ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Logo Position", "ts_visual_composer_extend" ),
				"param_name"            => "video_logo_position",
				"width"                 => 150,
				"value"                 => array(
					__( 'Top Left', "ts_visual_composer_extend" )			=> "topleft",
					__( 'Top Right', "ts_visual_composer_extend" )			=> "topright",
					__( 'Bottom Left', "ts_visual_composer_extend" )		=> "bottomleft",
					__( 'Bottom Right', "ts_visual_composer_extend" )		=> "bottomright",
				),
				"description"           => __( "Select the position for the logo that will be shown on top of the media.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_logo_show", 'value' => 'logotop' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Max. Logo Height", "ts_visual_composer_extend" ),
				"param_name"            => "video_logo_height",
				"value"                 => "50",
				"min"                   => "25",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define the maximum height in px for the logo that is shown on top of the media.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_logo_show", 'value' => 'logotop' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Logo Opacity", "ts_visual_composer_extend" ),
				"param_name"            => "video_logo_opacity",
				"value"                 => "50",
				"min"                   => "0",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Define the opacity for the logo that is shown on top of the media.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "video_logo_show", 'value' => array('logotop','logocontrol') ),
				"group" 				=> "Player Settings",
			),
			array(
				"type" 					=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ParameterLinkPicker['enabled'] == "false" ? "vc_link" : "advancedlinks"),
				"heading" 				=> __("Logo Link + Title", "ts_visual_composer_extend"),
				"param_name" 			=> "video_logo_link",
				"description" 			=> __("Provide an optional link to another site/page for the logo.", "ts_visual_composer_extend"),
				"dependency"            => array( 'element' => "video_logo_show", 'value' => array('logotop','logocontrol') ),
				"group" 				=> "Player Settings",
			),
			// Border Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_4",
				"seperator"				=> "Border Settings",
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Border Type", "ts_visual_composer_extend" ),
				"param_name"        	=> "frame_border_type",
				"width"             	=> 300,
				"value"             	=> array(
					__( "None", "ts_visual_composer_extend" )                          => "none",
					__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
					__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
					__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
					__( "Double Border", "ts_visual_composer_extend" )                 => "double",
					__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
					__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
					__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
					__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
				),
				"description"       	=> __( "Select the type of border around the video frame.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Border Width", "ts_visual_composer_extend" ),
				"param_name"            => "frame_border_width",
				"value"                 => "1",
				"min"                   => "0",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define the border width around the video frame.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "frame_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
				"group" 				=> "Player Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Border Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "frame_border_color",
				"value"             	=> "#dadada",
				"description"       	=> __( "Define the border color around the video frame.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "frame_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
				"group" 				=> "Player Settings",
			),
			// Lightbox Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_5",
				"seperator"				=> "Lightbox Settings",
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )                 	=> "auto",
					__( 'Set Width (%)', "ts_visual_composer_extend" )        	=> "widthpercent",
					__( 'Set Width (px)', "ts_visual_composer_extend" )       	=> "widthpixel",
				),
				"description"           => __( "Select how the maximum element width inside the lightbox should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width_percent",
				"value"                 => "100",
				"min"                   => "25",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the maximum element width inside the lightbox in percent.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_width", 'value' => 'widthpercent' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width_pixel",
				"value"                 => "960",
				"min"                   => "1",
				"max"                   => "1920",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the maximum element width inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_width", 'value' => 'widthpixel' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )                 	=> "auto",
					__( 'Set Height (%)', "ts_visual_composer_extend" )      	=> "heightpercent",
					__( 'Set Height (px)', "ts_visual_composer_extend" )      	=> "heightpixel",
				),
				"description"           => __( "Select how the maximum element height inside the lightbox should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height_percent",
				"value"                 => "100",
				"min"                   => "25",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the maximum element height inside the lightbox in percent.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_height", 'value' => 'heightpercent' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height_pixel",
				"value"                 => "540",
				"min"                   => "100",
				"max"                   => "1080",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the maximum element height inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_height", 'value' => 'heightpixel' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Group Name", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_group_name",
				"value"                 => "krautgroup",
				"description"           => __( "Enter a custom group name to manually build group with other video items; leave empty for non-grouping", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => "true" ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Transition Effect", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_effect",
				"width"                 => 150,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
				"default" 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"std" 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"description"           => __( "Select the transition effect to be used for the image in the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Backlight Color", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_backlight_choice",
				"width"                 => 150,
				"value"                 => array(
					__( 'Predefined Color', "ts_visual_composer_extend" )											=> "predefined",
					__( 'Custom Color', "ts_visual_composer_extend" )												=> "customized",
					__( 'Transparent Backlight', "ts_visual_composer_extend" )     	=> "hideit",
				),
				"description"           => __( "Select the (backlight) color style for the popup box.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Select Backlight Color", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_backlight_color",
				"width"                 => 150,
				"value"                 => array(
					__( 'Default', "ts_visual_composer_extend" )      		=> "#0084E2",
					__( 'Neutral', "ts_visual_composer_extend" )      		=> "#FFFFFF",
					__( 'Success', "ts_visual_composer_extend" )      		=> "#4CFF00",
					__( 'Warning', "ts_visual_composer_extend" )      		=> "#EA5D00",
					__( 'Error', "ts_visual_composer_extend" )        		=> "#CC0000",
					__( 'None', "ts_visual_composer_extend" )         		=> "#000000",
				),
				"description"           => __( "Select the predefined backlight color for the modal popup.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_backlight_choice", 'value' => 'predefined' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Select Backlight Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "lightbox_backlight_custom",
				"value"             	=> "#000000",
				"description"       	=> __( "Define a custom backlight color for the modal popup.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_backlight_choice", 'value' => 'customized' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Show on Page Load", "ts_visual_composer_extend" ),
				"param_name"		    => "content_open",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want show the popup on page load (limit to one per page).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Hide Popup Trigger on Page", "ts_visual_composer_extend" ),
				"param_name"		    => "content_open_hide",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want show or hide the popup trigger on the page.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_open", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Time Delay", "ts_visual_composer_extend" ),
				"param_name"            => "content_open_delay",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "10000",
				"step"                  => "100",
				"unit"                  => 'ms',
				"description"           => __( "Define the delay in ms until the modal popup should be shown (starting from 'Document Ready').", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_open", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			// Lightbox Triggger
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_6",
				"seperator"				=> "Trigger Settings",
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Trigger Type", "ts_visual_composer_extend" ),
				"param_name"            => "content_trigger",
				"value"                 => array(
					__("Poster Image", "ts_visual_composer_extend")          	=> "poster",
					__("Default Image", "ts_visual_composer_extend")          	=> "default",
					__("Custom Image", "ts_visual_composer_extend")           	=> "image",
					__("Font Icon", "ts_visual_composer_extend")              	=> "icon",
					__("Winged Button", "ts_visual_composer_extend")          	=> "winged",
					__("Simple Button", "ts_visual_composer_extend")          	=> "simple",
					__("Flat Icon Button", "ts_visual_composer_extend")       	=> "flaticon",
					__("Flat Button", "ts_visual_composer_extend")       		=> "flat",
					__("Text", "ts_visual_composer_extend")                   	=> "text",
					__("Custom HTML", "ts_visual_composer_extend")            	=> "custom",
				),
				"description"           => __( "Select the type of trigger to click on in order to show the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Trigger Settings",
			),
			// Custom Image
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Select Image", "ts_visual_composer_extend" ),
				"param_name"            => "content_image",
				"value"                 => "",
				"description"           => __( "Select the preview image for the modal popup.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Simple Image Only", "ts_visual_composer_extend" ),
				"param_name"		    => "content_image_simple",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want display just the image without any styling.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Auto Height Setting", "ts_visual_composer_extend" ),
				"param_name"            => "content_image_height",
				"width"                 => 150,
				"value"                 => array(
					__( '100% Height Setting', "ts_visual_composer_extend" )		=> "height: 100%;",
					__( 'Auto Height Setting', "ts_visual_composer_extend" )     	=> "height: auto;",
				),
				"description"           => __( "Select what CSS height setting should be applied to the image (change only if image height does not display correctly).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('poster', 'default', 'image') ),
				"group" 				=> "Trigger Settings",
			),
			// Font Icon
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Select Icon', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'content_icon',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon you want to display.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('icon', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Icon Size", "ts_visual_composer_extend" ),
				"param_name"            => "content_iconsize",
				"value"                 => "30",
				"min"                   => "16",
				"max"                   => "512",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the icon size", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Icon Color", "ts_visual_composer_extend" ),
				"param_name"            => "content_iconcolor",
				"value"                 => "#cccccc",
				"description"           => __( "Define the color of the icon.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			// Flat Button
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Color Style", "ts_visual_composer_extend" ),
				"param_name"            => "content_buttonstyle",
				"width"                 => 300,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Default_Colors,
				"description"           => __( "Select the general color style for button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Hover Style", "ts_visual_composer_extend" ),
				"param_name"            => "content_buttonhover",
				"width"                 => 300,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Hover_Colors,
				"description"           => __( "Select the general hover style for button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			// Button
			array(
				"type"                  => "textfield",
				"heading"               => __( "Button Text", "ts_visual_composer_extend" ),
				"param_name"            => "content_buttontext",
				"value"                 => "View Video",
				"description"           => __( "Enter the text for the button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('winged', 'simple', 'flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Button Text Size", "ts_visual_composer_extend" ),
				"param_name"            => "content_buttonsize",
				"value"                 => "16",
				"min"                   => "12",
				"max"                   => "20",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			// Text Link
			array(
				"type"                  => "textfield",
				"heading"               => __( "Trigger Text", "ts_visual_composer_extend" ),
				"param_name"            => "content_text",
				"value"                 => "",
				"description"           => __( "Enter the trigger text for the modal popup.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => 'text' ),
				"group" 				=> "Trigger Settings",
			),
			// Custom Code
			array(
				"type"                  => "textarea_raw_html",
				"heading"               => __("Raw HTML", "ts_visual_composer_extend"),
				"param_name"            => "content_raw",
				"value"                 => base64_encode(""),
				"description"           => __("Enter your custom HTML code; code will be wrapped in appropriate link automatically.", "ts_visual_composer_extend"),
				"dependency"            => array( 'element' => "content_trigger", 'value' => 'custom' ),
				"group" 				=> "Trigger Settings",
			),
			// Subtitle
			array(
				"type"                  => "textfield",
				"heading"               => __( "Subtitle", "ts_visual_composer_extend" ),
				"param_name"            => "content_subtitle",
				"value"                 => "",
				"description"           => __( "Enter a subtitle for video trigger.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_trigger", 'value' => array('winged') ),
				"group" 				=> "Trigger Settings",
			),			
			// Overlay Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_7",
				"seperator"             => "Overlay Settings",
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),				
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Background Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_background",
				"value"             	=> "rgba(24, 24, 24, 0.3)",
				"description"       	=> __( "Select the background color and opacity for the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",	
				"group" 				=> "Trigger Settings"
			),		
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Overlay: Animation", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_animation",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Zoom Effect", "ts_visual_composer_extend" )				=> "zoom",
					__( "Zoom + Rotate Effect", "ts_visual_composer_extend" )		=> "rotate",
					__( "No Effect", "ts_visual_composer_extend" )					=> "none",
				),
				"description"       	=> __( "Select if and what type of animation should be applied to the image on hover.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Trigger Settings"
			),			
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Overlay: Decoration", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_decoration",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Default Image", "ts_visual_composer_extend" )				=> "default",
					__( "Custom Internal Image", "ts_visual_composer_extend" )		=> "image",
					__( "Custom External Image", "ts_visual_composer_extend" )		=> "external",
					__( "Font Icon", "ts_visual_composer_extend" )					=> "icon",
					__( "No Decoration", "ts_visual_composer_extend" )				=> "none",
				),
				"description"       	=> __( "Select if and how the overlay should be decorated.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Overlay: Visibility", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_visibility",
				"width"             	=> 300,
				"value"             	=> array(
					__( "Show Only On Hover", "ts_visual_composer_extend" )			=> "hover",
					__( "Always Show Decoration", "ts_visual_composer_extend" )		=> "only_deco",
					__( "Always Show Title", "ts_visual_composer_extend" )			=> "only_title",
					__( "Always Show Full Overlay", "ts_visual_composer_extend" )	=> "always",
				),
				"admin_label"           => true,
				"description"       	=> __( "Select if and when the overlay should be visible.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"              	=> "attach_image",
				"heading"           	=> __( "Overlay: Decoration Image", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_image",
				"value"             	=> "",
				"description"       	=> __( "Select an image to be used as decoration for the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),	
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Overlay: Decoration Image", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_external",
				"value"             	=> "",
				"description"       	=> __( "Enter the full path to the image to be used as decoration for the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'external' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Overlay: Decoration Icon', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'overlay_icon_name',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon to be used as decoration for the overlay.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Decoration Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_icon_color",
				"value"             	=> "#ededed",
				"description"       	=> __( "Select the color for the decoration element.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Overlay: Decoration Size", "ts_visual_composer_extend" ),
				"param_name"            => "overlay_size",
				"value"                 => "100",
				"min"                   => "50",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define the size of the decoration element in the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => array('icon', 'image', 'external') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Overlay: Decoration Opacity", "ts_visual_composer_extend" ),
				"param_name"            => "overlay_opacity",
				"value"                 => "75",
				"min"                   => "50",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Define the opacity of the decoration element in the overlay.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "overlay_decoration", 'value' => array('icon', 'image', 'external') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Title Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_title_color",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Select the font color for the overlay title.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Overlay: Title Background", "ts_visual_composer_extend" ),
				"param_name"        	=> "overlay_title_back",
				"value"             	=> "rgba(0, 0, 0, 0.4)",
				"description"       	=> __( "Select the background color and opacity for the overlay title.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "content_trigger", 'value' => array('default', 'image', 'poster') ),
				"group" 				=> "Trigger Settings",
			),
			// Tooltip Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_8",
				"seperator"				=> "Trigger Tooltip",
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( "Use Advanced Tooltip", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_css",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want to apply am advanced tooltip to the image.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"				    => "textarea",
				"heading"			    => __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_content",
				"value"				    => "",
				"description"		    => __( "Enter the tooltip content here (do not use quotation marks or HTML code).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip_css", 'value' => "false" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           	=> __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_tooltip_encoded",
				"minimal"				=> "true",
				"value"             	=> base64_encode(""),
				"description"      	 	=> __( "Enter the tooltip content here (HTML code can be used).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip_css", 'value' => "true" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_position",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Vertical,
				"description"		    => __( "Select the tooltip position in relation to the image.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_style",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Layouts,
				"description"		    => __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			// Other Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_8",
				"seperator"				=> "Other Settings",
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"            => "margin_top",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"            => "margin_bottom",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"            => "el_id",
				"value"                 => "",
				"description"           => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "tag_editor",
				"heading"           	=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            => "el_class",
				"value"                 => "",
				"description"      		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
		)
	);		
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>